unit MainUnit;

//  
//     
// TrackBar,      .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    TrackBar2: TTrackBar;
    Bevel1: TBevel;
    TrackBar1: TTrackBar;
    LabelTitle: TLabel;
    Label1: TLabel;
    Label8: TLabel;
    Label3: TLabel;
    STextPositionBar1: TStaticText;
    Label2: TLabel;
    CBoxTickStyle: TComboBox;
    CBoxTickMark: TComboBox;
    Label4: TLabel;
    STextPositionBar2: TStaticText;
    Label5: TLabel;
    CBoxThumbLength: TComboBox;
    Label6: TLabel;
    CBoxFrequency: TComboBox;
    Label7: TLabel;
    CBoxMax: TComboBox;
    ButtonExit: TButton;
    procedure TrackBar1Change(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure CBoxTickStyleChange(Sender: TObject);
    procedure CBoxTickMarkChange(Sender: TObject);
    procedure CBoxThumbLengthChange(Sender: TObject);
    procedure CBoxFrequencyChange(Sender: TObject);
    procedure CBoxMaxChange(Sender: TObject);
    procedure ButtonExitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// --------------------------------------------------
//    
// --------------------------------------------------
procedure TForm1.TrackBar1Change(Sender: TObject);
begin
 STextPositionBar1.Caption:=IntToStr(TrackBar1.Position);
end;

procedure TForm1.TrackBar2Change(Sender: TObject);
begin
 STextPositionBar2.Caption:=IntToStr(TrackBar2.Position);
end;
// --------------------------------------------------
//    
// --------------------------------------------------
procedure TForm1.CBoxTickStyleChange(Sender: TObject);
begin
 case CBoxTickStyle.ItemIndex of
 0 : begin
       TrackBar1.TickStyle := tsNone;
       TrackBar2.TickStyle := tsNone;
     end;
 1 : begin
       TrackBar1.TickStyle := tsAuto;
       TrackBar2.TickStyle := tsAuto;
     end;
 2 : begin
       TrackBar1.TickStyle := tsManual;
       TrackBar2.TickStyle := tsManual;
     end;
 end;
end;

procedure TForm1.CBoxTickMarkChange(Sender: TObject);
begin
 case CBoxTickMark.ItemIndex of
 0 : begin
       TrackBar1.TickMarks := tmBottomRight;
       TrackBar2.TickMarks := tmBottomRight;
     end;
 1 : begin
       TrackBar1.TickMarks := tmTopLeft;
       TrackBar2.TickMarks := tmTopLeft;
     end;
 2 : begin
       TrackBar1.TickMarks := tmBoth;
       TrackBar2.TickMarks := tmBoth;
     end;
 end;
end;

procedure TForm1.CBoxThumbLengthChange(Sender: TObject);
var ThumbLen : integer;
begin
 ThumbLen := 20;
 case CBoxThumbLength.ItemIndex of
 0 : ThumbLen := 15;
 1 : ThumbLen := 20;
 2 : ThumbLen := 25;
 end;
 TrackBar1.ThumbLength := ThumbLen;
 TrackBar2.ThumbLength := ThumbLen;
end;

procedure TForm1.CBoxFrequencyChange(Sender: TObject);
var Frequency : integer;
begin
 Frequency := 1;
 case CBoxFrequency.ItemIndex of
 0 : Frequency := 1;
 1 : Frequency := 2;
 2 : Frequency := 5;
 3 : Frequency := 10;
 end;
 TrackBar1.Frequency := Frequency;
 TrackBar2.Frequency := Frequency;
end;

procedure TForm1.CBoxMaxChange(Sender: TObject);
var Max : integer;
begin
 Max := 20;
 case CBoxMax.ItemIndex of
 0 : Max := 10;
 1 : Max := 20;
 2 : Max := 30;
 3 : Max := 40;
 end;
 TrackBar1.Max := Max;
 TrackBar2.Max := Max;
end;

//     
procedure TForm1.ButtonExitClick(Sender: TObject);
begin
 Close;
end;

end.
